using System;
using System.Collections.Generic;

namespace _6Baki_i_Srecko
{
    internal class Program
    {
        struct Pomeraj
        {
            public double angle;
            public int i;
            public int type; // +1 = ukljuci, -1 = iskljuci
        }
        static int PorediPomeraje(Pomeraj a, Pomeraj b)
        {
            if (a.angle < b.angle) return -1;
            if (a.angle > b.angle) return 1;
            return 0;
        }

        static void Main()
        {
            int n = int.Parse(Console.ReadLine());
            long[] x = new long[n];
            long[] y = new long[n];

            for (int i = 0; i < n; i++)
            {
                string[] s = Console.ReadLine().Split();
                x[i] = long.Parse(s[0]);
                y[i] = long.Parse(s[1]);
            }
            const double half_pi = Math.PI / 2;
            const double full_circle = 2 * Math.PI;

            List<Pomeraj> list = new List<Pomeraj>(2 * n);

            for (int i = 0; i < n; i++)
            {
                double ang = Math.Atan2(y[i], x[i]);

                double enter = ang - half_pi;
                double exit = ang + half_pi;

                if (enter < -Math.PI) enter += full_circle;
                if (exit > Math.PI) exit -= full_circle;

                if (enter <= exit)
                {
                    list.Add(new Pomeraj { angle = enter, i = i, type = 1 });
                    list.Add(new Pomeraj { angle = exit, i = i, type = -1 });
                }
                else
                {
                    list.Add(new Pomeraj { angle = enter, i = i, type = 1 });
                    list.Add(new Pomeraj { angle = Math.PI, i = i, type = -1 });
                    list.Add(new Pomeraj { angle = -Math.PI, i = i, type = 1 });
                    list.Add(new Pomeraj { angle = exit, i = i, type = -1 });
                }
            }

            list.Sort(PorediPomeraje);

            HashSet<int> activeSet = new HashSet<int>();
            HashSet<int> BestSet = new HashSet<int>();

            long curX = 0;
            long curY = 0;
            long bestX = 0;
            long bestY = 0;

            foreach (Pomeraj p in list)
            {
                int ind = p.i;

                if (p.type == 1)
                {
                    activeSet.Add(ind);
                    curX += x[ind];
                    curY += y[ind];
                }
                else//-1
                {
                    activeSet.Remove(ind);
                    curX -= x[ind];
                    curY -= y[ind];
                }

                long dist = curX * curX + curY * curY;
                long maxDist = bestX * bestX + bestY * bestY;

                if (dist > maxDist)
                {
                    bestX = curX;
                    bestY = curY;
                    BestSet = activeSet;
                }
            }
            bestSet.Sort();
            Console.WriteLine(bestSet.Count);
            foreach (int p in bestSet)
            {
                Console.Write(p + 1 + " ");
            }
            Console.WriteLine();
        }
    }
}